/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.mixin;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.yggdrasil.response.MinecraftTexturesPayload;
import com.mojang.util.UUIDTypeAdapter;
import com.therandomlabs.randompatches.RPConfig;
import com.therandomlabs.randompatches.RandomPatches;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import org.apache.commons.codec.binary.Base64;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={CompoundNBT.class})
public final class CompoundNBTMixin {
    @Unique
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();

    @Redirect(method={"equals"}, at=@At(value="INVOKE", target="java/util/Objects.equals(Ljava/lang/Object;Ljava/lang/Object;)Z"))
    private boolean areTagMapsEqual(Object object1, Object object2) {
        RPConfig.PlayerHeadStackingFixMode mode = RandomPatches.config().misc.bugFixes.fixPlayerHeadStacking;
        if (mode == RPConfig.PlayerHeadStackingFixMode.DISABLED) {
            return Objects.equals(object1, object2);
        }
        if (Objects.equals(object1, object2)) {
            return true;
        }
        INBT skullOwner1 = (INBT)((Map)object1).get("SkullOwner");
        if (!(skullOwner1 instanceof CompoundNBT)) {
            return false;
        }
        INBT skullOwner2 = (INBT)((Map)object2).get("SkullOwner");
        if (!(skullOwner2 instanceof CompoundNBT)) {
            return false;
        }
        GameProfile profile1 = NBTUtil.func_152459_a((CompoundNBT)((CompoundNBT)skullOwner1));
        GameProfile profile2 = NBTUtil.func_152459_a((CompoundNBT)((CompoundNBT)skullOwner2));
        if (profile1 == null || !profile1.equals((Object)profile2)) {
            return false;
        }
        if (mode == RPConfig.PlayerHeadStackingFixMode.REQUIRE_SAME_PLAYER) {
            return true;
        }
        MinecraftProfileTexture texture1 = CompoundNBTMixin.getSkin(profile1);
        MinecraftProfileTexture texture2 = CompoundNBTMixin.getSkin(profile2);
        return texture1 != null && texture2 != null && texture1.getUrl().equals(texture2.getUrl());
    }

    @Unique
    private static @Nullable MinecraftProfileTexture getSkin(GameProfile profile) {
        MinecraftTexturesPayload payload = CompoundNBTMixin.getTexturesPayload(profile);
        return payload == null ? null : (MinecraftProfileTexture)payload.getTextures().get(MinecraftProfileTexture.Type.SKIN);
    }

    @Unique
    private static @Nullable MinecraftTexturesPayload getTexturesPayload(GameProfile profile) {
        Property textureProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get((Object)"textures"), null);
        if (textureProperty == null) {
            return null;
        }
        return (MinecraftTexturesPayload)gson.fromJson(new String(Base64.decodeBase64((String)textureProperty.getValue()), StandardCharsets.UTF_8), MinecraftTexturesPayload.class);
    }
}

